//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "UHorse.h"
//---------------------------------------------------------------------------
//                          PATA DIANTEIRA
//---------------------------------------------------------------------------
PataDianteira::PataDianteira(int __lado) {
  lado = __lado;
  anguloSuperior = 0;
  anguloMedio = 0;
  anguloInferior = 0;
}
//---------------------------------------------------------------------------
void PataDianteira::setAnguloSuperior(int __anguloSuperior) {
  anguloSuperior = __anguloSuperior;
}

//---------------------------------------------------------------------------
void PataDianteira::setAnguloInferior(int __anguloInferior) {
  anguloInferior = __anguloInferior;
}

//---------------------------------------------------------------------------
void PataDianteira::setAnguloMedio(int __anguloMedio) {
  anguloMedio = __anguloMedio;
}

//---------------------------------------------------------------------------
void PataDianteira::setAngulos(double __posicaoMovimento, int __tipoCaminhada) {
  double posAtual;
  if (__tipoCaminhada == 0) {                /// Caminhada
    if ((__posicaoMovimento>=0)&&(__posicaoMovimento<=0.17)) {
      posAtual = __posicaoMovimento * 100;
      /// Sup = -33.4 || Med = 26  || Inf = 48
      anguloSuperior = 37.4 + (-1.9647*posAtual);
      anguloMedio = -30 + (1.5294*posAtual);
      anguloInferior = -18 + (2.8235*posAtual);
    } else if ((__posicaoMovimento>=0.18)&&(__posicaoMovimento<=0.40)) {
      posAtual = (__posicaoMovimento-0.17) * 100;
      /// Sup = -22 || Med = 4  || Inf = 17
      anguloSuperior = 4 + (-0.9565*posAtual);
      anguloMedio = -4 + (0.1739*posAtual);
      anguloInferior = 30 + (0.7391*posAtual);
    } else if ((__posicaoMovimento>=0.41)&&(__posicaoMovimento<=0.63)) {
      posAtual = (__posicaoMovimento-0.40) * 100;
      /// Sup = 11 || Med = -33  || Inf = -73
      anguloSuperior = -18 + (0.478*posAtual);
      anguloMedio = 0 + (-1.4347*posAtual);
      anguloInferior = 47 + (-3.1739*posAtual);
    } else if ((__posicaoMovimento>=0.64)&&(__posicaoMovimento<=0.84)) {
      posAtual = (__posicaoMovimento-0.63) * 100;
      /// Sup = 50 || Med = -48  || Inf = -6
      anguloSuperior = -7 + (2.3809*posAtual);
      anguloMedio = -33 + (-2.2857*posAtual);
      anguloInferior = -26 + (-0.2857*posAtual);
    } else if ((__posicaoMovimento>=0.85)&&(__posicaoMovimento<=0.99)) {
      posAtual = (__posicaoMovimento-0.84) * 100;
      /// Sup = -5.6 || Med = 51  || Inf = 14
      anguloSuperior = 43 + (-0.3733*posAtual);
      anguloMedio = -81 + (3.4*posAtual);
      anguloInferior = -32 + (0.9333*posAtual);
    }
  } else if (__tipoCaminhada == 1) {          /// Galope
    if ((__posicaoMovimento>=0)&&(__posicaoMovimento<=0.17)) {
      posAtual = __posicaoMovimento * 100;
      /// Sup = -59.5 || Med = 5.4  || Inf = 67.4
      anguloSuperior = 31.8 + (-3.5*posAtual);
      anguloMedio = -5.4 + (0.317*posAtual);
      anguloInferior = -2 + (3.96*posAtual);
    } else if ((__posicaoMovimento>=0.18)&&(__posicaoMovimento<=0.33)) {
      posAtual = (__posicaoMovimento-0.17) * 100;
      /// Sup = 47.8 || Med = -100  || Inf = -65.4
      anguloSuperior = -27.8 + (2.987*posAtual);
      anguloMedio = 0 + (-6.25*posAtual);
      anguloInferior = 65.4 + (-4.087*posAtual);
    } else if ((__posicaoMovimento>=0.34)&&(__posicaoMovimento<=0.63)) {
      posAtual = (__posicaoMovimento-0.33) * 100;
      /// Sup = 74 || Med = 64  || Inf = -10.3
      anguloSuperior = 20 + (2.466*posAtual);
      anguloMedio = -100 + (2.133*posAtual);
      anguloInferior = 0 + (-0.34*posAtual);
    } else if ((__posicaoMovimento>=0.64)&&(__posicaoMovimento<=0.99)) {
      posAtual = (__posicaoMovimento-0.63) * 100;
      /// Sup = -63.2 || Med = 30.6  || Inf = 8.3
      anguloSuperior = 94 + (-1.91515*posAtual);
      anguloMedio = -36 + (0.927*posAtual);
      anguloInferior = -10.3 + (0.2515*posAtual);
    }
  } else if (__tipoCaminhada == 2) {  /// parado
    anguloSuperior = 4;
    anguloMedio = -4;
    anguloInferior = 30;
  }
}

//---------------------------------------------------------------------------
void PataDianteira::desenha(int __lado) {
  glPushMatrix();
    if (__lado == 0)
    	glTranslatef(1.1f,-0.35f,0.3f);
    else
      glTranslatef(1.1f,-0.35f,-0.3f);
//    glScalef(1.0,0.6,1.0);
    glRotatef(anguloSuperior,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    /////osso superior
    glTranslatef(0.0f,-0.4f,0.0f);
    glScalef(1.5,3,1.0);
    glutSolidCube(0.2);
    ///// junta do meio
    glScalef(1.0/1.5,0.3333,1.0);
    glTranslatef(0.0f,-0.4f,0.0f);
    glRotatef(anguloMedio,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    ///// osso do meio
    glTranslatef(0.0f,-0.25f,0.0f);
    glScalef(0.8,1.5,0.8);
    glutSolidCube(0.2);
    ///// junta inferior
    glScalef(1.0/0.8,1/1.5,1.0/0.8);
    glTranslatef(0.0f,-0.25f,0.0f);
    glRotatef(anguloInferior,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    ///// osso inferior
    glTranslatef(0.0f,-0.15f,0.0f);
    glScalef(2.0,1,2.0);
    glutSolidCube(0.1);
  glPopMatrix();
}

//---------------------------------------------------------------------------
//                          PATA TRASEIRA
//---------------------------------------------------------------------------
PataTraseira::PataTraseira(int __lado) {
  lado = __lado;
}

//---------------------------------------------------------------------------
void PataTraseira::setAngulos(double __posicaoMovimento, int __tipoCaminhada) {
  double posAtual;
  if (__tipoCaminhada == 0) {     ////caminhada
    if ((__posicaoMovimento>=0)&&(__posicaoMovimento<=0.17)) {
      posAtual = __posicaoMovimento * 100;
      /// Sup = -24.2 || MedSup = 4.8  || MedInf = -1 || Inf = -8
      anguloSuperior = 4.2 + (-1.4235*posAtual);
      anguloMedioSup = -30.8 + (0.2823*posAtual);
      anguloMedioInf = 40 + (-0.0588*posAtual);
      anguloInferior = 40 + (-0.4705*posAtual);
    } else if ((__posicaoMovimento>=0.18)&&(__posicaoMovimento<=0.33)) {
      posAtual = (__posicaoMovimento-0.17) * 100;
      /// Sup = -17 || MedSup = 11  || MedInf = 1 || Inf = -61
      anguloSuperior = -20 + (-1.0625*posAtual);
      anguloMedioSup = -26 + (0.6875*posAtual);
      anguloMedioInf = 39 + (0.0625*posAtual);
      anguloInferior = 32 + (-3.8125*posAtual);
    } else if ((__posicaoMovimento>=0.34)&&(__posicaoMovimento<=0.63)) {
      posAtual = (__posicaoMovimento-0.33) * 100;
      /// Sup = 50 || MedSup = -9  || MedInf = 24 || Inf = 2
      anguloSuperior = -37 + (1.6666*posAtual);
      anguloMedioSup = -15 + (-0.3*posAtual);
      anguloMedioInf = 40 + (0.8*posAtual);
      anguloInferior = -29 + (0.06666*posAtual);
    } else if ((__posicaoMovimento>=0.64)&&(__posicaoMovimento<=0.83)) {
      posAtual = (__posicaoMovimento-0.63) * 100;
      /// Sup = -8 || MedSup = -4  || MedInf = -26 || Inf = 64
      anguloSuperior = 13 + (-0.4*posAtual);
      anguloMedioSup = -24 + (-0.2*posAtual);
      anguloMedioInf = 64 + (-1.3*posAtual);
      anguloInferior = -27 + (3.2*posAtual);
    } else if ((__posicaoMovimento>=0.84)&&(__posicaoMovimento<=0.99)) {
      posAtual = (__posicaoMovimento-0.83) * 100;
      /// Sup = -0.8 || MedSup = -10.8  || MedInf = 2 || Inf = 3
      anguloSuperior = 5 + (-0.05*posAtual);
      anguloMedioSup = -20 + (-0.675*posAtual);
      anguloMedioInf = 38 + (0.125*posAtual);
      anguloInferior = 37 + (0.1875*posAtual);
    }
  } else if (__tipoCaminhada == 1) {  /// galope
    if ((__posicaoMovimento>=0)&&(__posicaoMovimento<=0.17)) {
      posAtual = __posicaoMovimento * 100;
      /// Sup = 36 || MedSup = -37  || MedInf = 38 || Inf = -22
      anguloSuperior = -22 + (2.117*posAtual);
      anguloMedioSup = -69 + (-2.176*posAtual);
      anguloMedioInf = 42 + (2.235*posAtual);
      anguloInferior = 0 + (1.294*posAtual);
    } else if ((__posicaoMovimento>=0.18)&&(__posicaoMovimento<=0.33)) {
      posAtual = (__posicaoMovimento-0.17) * 100;
      /// Sup = 26 || MedSup = 26  || MedInf = 47 || Inf = -31
      anguloSuperior = 14 + (1.625*posAtual);
      anguloMedioSup = -106 + (1.625*posAtual);
      anguloMedioInf = 80 + (2.9375*posAtual);
      anguloInferior = -22 + (-1.9375*posAtual);
    } else if ((__posicaoMovimento>=0.34)&&(__posicaoMovimento<=0.52)) {
      posAtual = (__posicaoMovimento-0.33) * 100;
      /// Sup = -13 || MedSup = 64  || MedInf = -94 || Inf = 63
      anguloSuperior = 40 + (-0.6842*posAtual);
      anguloMedioSup = -80 + (3.3684*posAtual);
      anguloMedioInf = 127 + (-4.4973*posAtual);
      anguloInferior = -53 + (3.3157*posAtual);
    } else if ((__posicaoMovimento>=0.53)&&(__posicaoMovimento<=0.73)) {
      posAtual = (__posicaoMovimento-0.52) * 100;
      /// Sup = -45 || MedSup = -36  || MedInf = 17 || Inf = 56
      anguloSuperior = 27 + (-2.1428*posAtual);
      anguloMedioSup = -16 + (-1.7142*posAtual);
      anguloMedioInf = 33 + (0.8095*posAtual);
      anguloInferior = 10 + (2.6666*posAtual);
    } else if ((__posicaoMovimento>=0.74)&&(__posicaoMovimento<=0.99)) {
      posAtual = (__posicaoMovimento-0.73) * 100;    
      /// Sup = -4 || MedSup = -17  || MedInf = -8 || Inf = -66
      anguloSuperior = -18 + (-0.1584*posAtual);
      anguloMedioSup = -52 + (-0.6538*posAtual);
      anguloMedioInf = 50 + (-0.3076*posAtual);
      anguloInferior = 66 + (-2.5384*posAtual);
    }
  } else if(__tipoCaminhada == 2) {  /// parado
    anguloSuperior = -20;
    anguloMedioSup = -26;
    anguloMedioInf = 39;
    anguloInferior = 32;
  }
}

//---------------------------------------------------------------------------
void PataTraseira::desenha(int __lado) {
  glPushMatrix();
    if (__lado == 0)
    	glTranslatef(-0.8f,0.2f,0.3f);
    else
      glTranslatef(-0.8f,0.2f,-0.3f);
    glRotatef(anguloSuperior,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    ///// osso superior
    glTranslatef(0.0f,-0.3f,0.0f);
    glScalef(2.3,2,1.0);
    glutSolidCube(0.2);
    ///// junta do meio superior
    glScalef(1.0/2.3,0.5,1.0);
    glTranslatef(0.0f,-0.3f,0.0f);
    glRotatef(anguloMedioSup,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    /////osso do meio superior
    glTranslatef(0.0f,-0.4f,0.0f);
    glScalef(1.4,3,1.0);
    glutSolidCube(0.2);
    ///// junta do meio inferior
    glScalef(1.0/1.4,0.3333,1.0);
    glTranslatef(0.0f,-0.4f,0.0f);
    glRotatef(anguloMedioInf,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    ///// osso do meio inferior
    glTranslatef(0.0f,-0.3f,0.0f);
    glScalef(0.8,2,0.8);
    glutSolidCube(0.2);
    ///// junta inferior
    glScalef(1.0/0.8,0.5,1.0/0.8);
    glTranslatef(0.0f,-0.3f,0.0f);
    glRotatef(anguloInferior,0,0,1);
    glutSolidSphere(0.1, 30, 30);
    ///// osso inferior
    glTranslatef(0.0f,-0.15f,0.0f);
    glScalef(2.0,1,2.0);
    glutSolidCube(0.1);
  glPopMatrix();
}

//---------------------------------------------------------------------------
//                               RABO
//---------------------------------------------------------------------------
Rabo::Rabo() {
  anguloX = 0;
  anguloZ = 75;
}

//---------------------------------------------------------------------------
void Rabo::desenha() {
  glPushMatrix();
    glTranslatef(-1.25f,0.25f,0.0f);
    glRotatef(-15, 0, 0 , 1);
    glScalef(0.25,0.1,0.1);
    glutSolidCube(2.0);
    glScalef(0.1/0.25,1.0,1.0);
    glTranslatef(-3.0f,-0.3f,0.0f);
    glRotatef(anguloZ, 0, 0 , 1);
    glRotatef(anguloX, 0, 1, 0);
    glutSolidCube(2.0);
    glScalef(3.5,1.0,1.0);
    glTranslatef(-1.3f,0.0f,0.0f);
    glutSolidCube(2.1);
  glPopMatrix();
}

void Rabo::setAngulos(double __posicaoMovimento, int __tipoCaminhada) {
  if (__tipoCaminhada == 0) {
    anguloZ = 75;
    if ((__posicaoMovimento >= 0)&&(__posicaoMovimento <= 0.49)) {
      anguloX = -30 + (1.2*__posicaoMovimento*100);
    } else if ((__posicaoMovimento >= 0.50)&&(__posicaoMovimento <= 1.00)) {
      anguloX = 30 - (1.2*(__posicaoMovimento-0.49)*100);
    }
  } else if (__tipoCaminhada == 1) {
    anguloX = 0;
    anguloZ = 15;
  } else if (__tipoCaminhada == 2) {
    anguloZ = 75;
    if ((__posicaoMovimento >= 0)&&(__posicaoMovimento <= 0.49)) {
      anguloX = -30 + (1.2*__posicaoMovimento*100);
    } else if ((__posicaoMovimento >= 0.50)&&(__posicaoMovimento <= 1.00)) {
      anguloX = 30 - (1.2*(__posicaoMovimento-0.49)*100);
    }
  }
}

//---------------------------------------------------------------------------
//                              CABECA
//---------------------------------------------------------------------------
Cabeca::Cabeca() {
  anguloPescoco = 35;
}

//---------------------------------------------------------------------------
void Cabeca::setAnguloPescoco(double __posicaoMovimento, int __tipoCaminhada) {
  if (__tipoCaminhada == 0) { ///caminhada
    if ((__posicaoMovimento >= 0)&&(__posicaoMovimento <= 0.24)) {
      anguloPescoco = 20 + (1.2*__posicaoMovimento*100);
    } else if ((__posicaoMovimento >= 0.25)&&(__posicaoMovimento <= 0.49)) {
      anguloPescoco = 50 - (1.2*(__posicaoMovimento-0.24)*100);
    } else if ((__posicaoMovimento >= 0.5)&&(__posicaoMovimento <= 0.74)) {
      anguloPescoco = 20 + (1.2*(__posicaoMovimento-0.49)*100);
    } else if ((__posicaoMovimento >= 0.75)&&(__posicaoMovimento <= 1.0)) {
      anguloPescoco = 50 - (1.2*(__posicaoMovimento-0.74)*100);
    }
  } else if(__tipoCaminhada == 1) { ///galope
    if ((__posicaoMovimento >= 0)&&(__posicaoMovimento <= 0.49)) {
      anguloPescoco = 27 + (0.32*__posicaoMovimento*100);
    } else if ((__posicaoMovimento >= 0.5)&&(__posicaoMovimento <= 1.00)) {
      anguloPescoco = 43 - (0.32*(__posicaoMovimento-0.49)*100);
    }
  } else if(__tipoCaminhada == 2) { ///parado
    anguloPescoco = 35;
  }
}

//---------------------------------------------------------------------------
void Cabeca::desenha() {
  glPushMatrix();
    /// articulao
    glTranslatef(0.9f,0.3f,0.0f);
    glRotatef(anguloPescoco,0,0,1);
    glutSolidSphere(0.2,30,30);
    /// pescoo
    glTranslatef(0.3f,0.0f,0.0f);
    glScalef(0.65,0.2,0.25);
    glutSolidCube(2.0);
    /// cabea
    glScalef(1/0.55,1/0.2,1/0.25);
    glTranslatef(0.5f,-0.2f,0.0f);
    glRotatef(-75, 0,0,1);
    glScalef(0.4,0.2,0.25);
    glutSolidCube(1.5);
  glPopMatrix();
}

//---------------------------------------------------------------------------
//                               CORPO
//---------------------------------------------------------------------------
Corpo::Corpo() {
  tipoCaminhada = 2;
  cabeca = new Cabeca();
  rabo = new Rabo();
  pataDiantDireita = new PataDianteira(0);
  pataDiantEsquerda = new PataDianteira(1);
  pataTrasDireita = new PataTraseira(0);
  pataTrasEsquerda = new PataTraseira(1);
}

//---------------------------------------------------------------------------
void Corpo::setTipoCaminhada(int __tipoCaminhada) {
  tipoCaminhada = __tipoCaminhada;
}

//---------------------------------------------------------------------------
void Corpo::setPosicao(double __posicaoMovimento) {
  pataDiantEsquerda->setAngulos(__posicaoMovimento, tipoCaminhada);
  pataTrasEsquerda->setAngulos(__posicaoMovimento, tipoCaminhada);
  cabeca->setAnguloPescoco(__posicaoMovimento, tipoCaminhada);
  rabo->setAngulos(__posicaoMovimento, tipoCaminhada);
  if (tipoCaminhada == 0) {
    __posicaoMovimento +=  0.5;
  } else if (tipoCaminhada == 1){
    __posicaoMovimento += 0.2;
  }
  if (__posicaoMovimento >=1.0)
    __posicaoMovimento = __posicaoMovimento - 1;
  pataDiantDireita->setAngulos(__posicaoMovimento, tipoCaminhada);
  pataTrasDireita->setAngulos(__posicaoMovimento, tipoCaminhada);
  glutPostRedisplay();
}

//---------------------------------------------------------------------------
void Corpo::desenha() {
  glPushMatrix();
  	glTranslatef(0.0f,5.0f,0.0f);
    glColor3f(0.45f,0.22f,0.0f);
    pataDiantDireita->desenha(0);
    pataDiantEsquerda->desenha(1);
    pataTrasDireita->desenha(0);
    pataTrasEsquerda->desenha(1);
    rabo->desenha();
    cabeca->desenha();
    glScalef(1.1,0.35,0.3);
    glutSolidCube(2);
  glPopMatrix();
}

//---------------------------------------------------------------------------

#pragma package(smart_init)
